#!/bin/sh
################################################################################
#                                                                              #
# Polish Koders Team 2010                                                      #
#                                                                              #
# contact: http://pkteam.pl                                                    #
#                                                                              #
################################################################################
#
# General puropses PKT script functions
# version $Revision: 300 $ $Date: 2010-12-31 21:05:58 +0100 (pią) $
#

E2_SETTINGS="/etc/enigma2/settings" 

                                                                                   
config_get() {	# value
  local key="$1"
  echo `grep "${key}=" "${E2_SETTINGS}" | cut -d "=" -f 2`
}

config_set() {	# value, key
  local key="$1"
  local value="$2"
  local oldval=$(config_get "${key}")
  grep "${key}" "${E2_SETTINGS}" >> /dev/null
  if [ "0" -eq "$?" ]; then
    #Key entry exsists
    if [ -z "$value" ]; then
      #Remove key entry
      sed -i "/${key}=.*/d" "${E2_SETTINGS}"
    elif [ "${value}" != "${oldval}" ]; then
      #Change value of key entry
      sed -i "s/${key}=.*/${key}=${value}/" "${E2_SETTINGS}"
    else
      #Key entry value is that same as new value
      #So don't touch it for safe eg. flash writes
      : #nop
    fi
  elif [ -z "${value}" ]; then
    #Key entry dosn't exist and value is empty
    : #nop
  else
    #Add new key entry
    echo "${key}=${value}" >> "${E2_SETTINGS}"
  fi
}

