#!/bin/sh
################################################################################
#                                                                              #
# Polish Kathi Team 2009                                                       #
#                                                                              #
# contact: http://pkteam.pl                                                    #
#                                                                              #
################################################################################
# rev 12
# added $cifs_local_directory for mountpoint
. /var/config/mount.conf
#. /var/config/cifs.conf
. /var/config/nfs.conf

#-------------------------------------------------------------------------------
#script section
#-------------------------------------------------------------------------------

mount_hdd()
{
 if [ $devs != brak ]; then

  fs_id=`fdisk -l | grep $devs | tr -d '*' | awk '{print $5}'`

    if [ $fs_id == 83 ]; then
       echo "Detect & mount ext2/3 partition on $devs"
       mount /dev/$devs /media/hdd/
    elif [ $fs_id == 6 ] || [ $fs_id == 5 ] || [ $fs_id == b ] || [ $fs_id == c ] || [ $fs_id == e ] || [ $fs_id == f ]; then
       echo "Detect & mount FAT16/32 partition on $devs"
       mount /dev/$devs /media/hdd/ -o shortname=mixed -t vfat
    elif [ $fs_id == 7 ]; then
       echo "Detect & mount HPFS/NTFS partition on $devs"
       mount /dev/$devs /media/hdd/ -t ntfs   
    else 
       echo "No such device"
    fi

  mkdir /media/hdd/movie 2>/dev/null
  mkdir /media/hdd/image 2>/dev/null
  /bin/vfdctl +hdd
 fi
}

mount_cifs()
{
 if [ -e /var/etc/active_cifs ]; then

    for cifs_cfg in /var/config/cifs*.conf; do
        . "$cifs_cfg"
        if [ -n "$cifs_address" ]; then
            if [ -n "$cifs_login" ]; then
                if [ -n "$cifs_directory" ]; then
                    if [ -n "$cifs_local_directory" ]; then
                        mkdir -p /mnt/$cifs_local_directory
                        mount -t cifs //$cifs_address/$cifs_directory /mnt/$cifs_local_directory -o user=$cifs_login,password=$cifs_pass
                    fi
                fi
            fi
        fi
      done

 fi
}

mount_nfs()
{
if [ -e /var/etc/active_nfs ]; then
   mount -t nfs $nfsserver:/$nfsdirectory /mnt/nfs
fi
} 

detect_dev()
{
 rm /var/etc/devices > /dev/null

 lista=`fdisk -l | grep '/dev/' | awk '{gsub("/"," "); print $2}' | awk '{gsub("dev",""); print $1}'`
 id=1

 for i in $lista; do
     echo "dev$id= $i" >> /var/etc/devices
     id=$(($id+1))
 done

 if [ -z "`cat /var/etc/devices | grep sd`" ]; then
     echo "Disk no_disk" > /var/etc/devices
 fi
}

#-------------------------------------------------------------------------------
#use section
#-------------------------------------------------------------------------------

case "$1" in
 'hdd')
    mount_hdd
    ;;
 'cifs')
    mount_cifs
    ;;
 'nfs')
    mount_nfs
    ;;
 'auto')
    mount_cifs
    mount_hdd
    mount_nfs
    ;;
 'detector')
    detect_dev
    ;;
 *)
    echo -e "\nUse: mountstarter.sh hdd|cifs|nfs|auto|detector"
    ;;
esac

exit 0