#!/bin/sh
################################################################################
#                                                                              #
# Polish Koders Team 2011                                                      #
#                                                                              #
# contact: http://pkteam.pl/                                                   #
#                                                                              #
################################################################################

. /var/config/swap.conf
. /var/config/symlink
box=`cat /etc/boxtype`

#-------------------------------------------------------------------------------
#script section
#-------------------------------------------------------------------------------

if [ $swap == on ]; then

   echo "_(Detecting SWAP partition, wait...)"
   id_swap=`fdisk -l | grep 'Linux swap' | awk '{print $5}' | head -n 1`
   echo ""

   if [ $id_swap == "82" ]; then
       swap_dev=`fdisk -l | grep 'Linux swap' | awk '{print $1}' | head -n 1`
       echo "_(SWAP detected on )" $swap_dev
       echo ""
       mkswap $swap_dev
       swapon $swap_dev
       echo ""
       #echo "SWAP PART ON" > /dev/vfd
       sleep 1
       echo "_(SWAP partition activated)"
       echo ""
   else
       echo "_(SWAP is missing or wrong partition type)"
       echo ""
       echo "_(SWAP file emulation activated)"
       echo ""
       echo "_(Wait...)"
       if [ $box != ufs912 ]; then
            $SYMLINK/swap.sh >/dev/null
            echo ""
            echo "_(SWAP mounted)"
            echo ""
       else       
            test=`mount | grep hdd | awk '{print $5}'`
            if [ $test != ntfs ] && [ -n "$test" ]; then
                $SYMLINK/swap.sh >/dev/null
                echo ""
                echo "_(SWAP mounted)"
                echo ""
            else
                echo ""
                echo "_(error: /hdd must be mounted)"
                echo ""
            fi
       fi
   fi

else

  if [ $box != ufs912 ]; then
    PATCH="/swap"
  else
    PATCH="/hdd/swap"
  fi

    if [ -e $PATCH/swapfile ]; then
        swapoff $PATCH/swapfile
        rm $PATCH/swapfile
        rmdir $PATCH/
    fi
  
    echo "_(SWAP is not active)"
    echo ""
    echo "_(If you want to use SWAP partition activate it)"
    echo ""
    echo "_(USB STICK or USB HARDDISK is REQUIRED)"
    echo ""
    echo "_(Supported Filesystem: ext2, ext3, vfat, LinuxSwap)"
    echo ""
fi

exit 0
