#!/bin/sh

PATH=/bin:/usr/bin:/sbin:/usr/sbin

create_node()
{
  device=$1
  
  rm -f /dev/${device}
  major=`awk "\\$2==\"$device\" {print \\$1}" /proc/devices`
  
  if [ ${major} ]; then
     echo Creating device node for $1
                mknod /dev/${device} c $major 0
  fi

}

echo "Running mknod now ......."

create_node "KAL"
create_node "notifyq"
create_node "platform"
create_node "Content"
create_node "standby"
#create_node "Audio"
#create_node "Video"
#create_node "PVR"
#create_node "fb"
#create_node "FrontEnd"
#create_node "ipfe"
create_node "CI"

mkdir -p /dev/dvb/adapter0
cd /dev/dvb/adapter0

mknod fe_sat0 c 212 0
mknod fe_sat1 c 212 1
#mknod fe_cable c 212 1
mknod fe_ter0 c 212 2
#mknod fe_atsc c 212 3
ln -s fe_sat0 frontend0
ln -s fe_sat1 frontend1
ln -s fe_ter0 frontend2
#ln -s fe_sat fe_sat0

mknod demux0 c 212 16
mknod demux1 c 212 17
mknod demux2 c 212 18
mknod demux3 c 212 19
mknod demux4 c 212 20

mknod dvr0 c 212 32
mknod dvr1 c 212 33
mknod dvr2 c 212 34
mknod dvr3 c 212 35
mknod dvr4 c 212 36

mknod video0 c 212 48
mknod video1 c 212 49

mknod audio0 c 212 64
mknod audio1 c 212 65

mknod ca0 c 212 80
mknod ca1 c 212 81
mknod ca2 c 212 82
mknod ca3 c 212 83
mknod ca4 c 212 84

#/root/iframe

#mount /dev/sda1 /hdd
mkdir -p /dev/dbox
mknod /dev/dbox/oled0 c 11 57
