#!/bin/sh

prefix=/usr
exec_prefix=/usr
datarootdir=${prefix}/share

# perform a NTP update sync, before starting Enigma2, as it is broke in OE.
#if [ -x /usr/sbin/ntpdate ]; then
#	/usr/sbin/ntpdate -s -u pool.ntp.org && sleep 2
#fi

# hook to execute user startup script before enigma2 start
if [ -x /etc/enigma2/startup.sh ]; then
	/etc/enigma2/startup.sh
fi

if [ -e /proc/stb/info/boxtype ]; then
	stbcheck=`cat /proc/stb/info/boxtype`
	if [ $stbcheck == "viper4k" ] || [ $stbcheck == "sf8008" ] || [ $stbcheck == "beyonwizv2" ] || [ $stbcheck == "ustym4kpro" ] || [ $stbcheck == "cc1" ] || [ $stbcheck == "gbtrio4k" ] ; then
		count=`ps -ef |grep libreader |grep -v "grep" |wc -l`
		if [ 0 == $count ];then
			libreader 720P_50
		fi
	fi
fi

if [ -x /usr/bin/showiframe ]; then
	if [ -f /etc/enigma2/backdrop.mvi ]; then
		/usr/bin/showiframe /etc/enigma2/backdrop.mvi
	else
		skin=`sed -En 's|config\.skin\.primary_skin=(.+)/skin\.xml|\1|p' /etc/enigma2/settings`
		if [ -z $skin ]; then
			skin=`strings -n 10 /usr/lib/enigma2/python/skin.pyo | egrep -o -m 1 ".+/skin.xml" | sed 's|/skin.xml.*||'`
		fi
		if [ -n $skin -a -f /usr/share/enigma2/$skin/backdrop.mvi ]; then
			/usr/bin/showiframe /usr/share/enigma2/$skin/backdrop.mvi
		elif [ -f /usr/share/backdrop.mvi ]; then
			/usr/bin/showiframe /usr/share/backdrop.mvi
		fi
	fi
fi

# hook to execute scripts always before enigma2 start
if [ -x /usr/bin/enigma2_pre_start.sh ]; then
	/usr/bin/enigma2_pre_start.sh
fi

if [ -d /home/root ]; then
	export HOME=/home/root
	cd
fi

#check for sundtek tuner helper lib
if [ -e /opt/lib/libmediaclient.so ]; then
	LIBS="/opt/lib/libmediaclient.so /usr/lib/libopen.so.0.0.0"
else
	LIBS="/usr/lib/libopen.so.0.0.0"
fi

sync

(sleep 2; echo "enigma2 is the main pvr application... adjust oom score!"; PID=$(pidof enigma2); \
	[ -e /proc/$PID/oom_score_adj ] && echo "-999" > /proc/$PID/oom_score_adj || echo "-17" > /proc/$PID/oom_adj;) &


# set time format used to prefix each line in the debug logs
if grep -q 'config\.crash\.logtimeformat' /etc/enigma2/settings; then
	export ENIGMA_DEBUG_TIME=`grep "config\.crash\.logtimeformat" /etc/enigma2/settings | sed -E "s/^.*=(.*)$/\1/" -`
fi

if grep -q 'config\.crash\.enabledebug=True' /etc/enigma2/settings; then
	debug_dir=$(sed -n 's/config.crash.debug_path=//p' /etc/enigma2/settings)
	[ -n "${debug_dir}" -a -d "${debug_dir}" ] || debug_dir=/home/root/logs/
	LD_PRELOAD=$LIBS /usr/bin/enigma2 &> "${debug_dir}Enigma2_debug_$(date +%Y-%m-%d_%H-%M-%S).log"
else
	if grep -q 'config\.misc\.firstrun=False' /etc/enigma2/settings; then
		LD_PRELOAD=$LIBS /usr/bin/enigma2 &> /dev/null
	else
		LD_PRELOAD=$LIBS /usr/bin/enigma2
	fi
fi

# enigma2 exit codes:
#
# 1 - halt
# 2 - reboot
# 3 - restart enigma
#
# >128 signal

ret=$?

if [ "$ret" -ne "1" ]; then
	if [ -e /proc/stb/info/boxtype ]; then
		stbcheck=`cat /proc/stb/info/boxtype`
		if [ $stbcheck == "viper4k" ] || [ $stbcheck == "sf8008" ] || [ $stbcheck == "beyonwizv2" ] || [ $stbcheck == "gbtrio4k" ] ; then
			killall -9 libreader; sleep 5
		fi
	fi
fi

case $ret in
	1)
		/sbin/halt
		;;
	2)
		/sbin/reboot
		;;
	3)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
	4)
		/sbin/rmmod lcd
		/usr/sbin/fpupgrade --upgrade 2>&1 | tee /home/root/fpupgrade.log
		sleep 1;
		/sbin/rmmod fp
		/sbin/modprobe fp
		/sbin/reboot
		;;
	12)
		if [ -e /dev/block/by-name/bootoptions ]; then
			mkdir -p /tmp/bootoptions
			mount /dev/block/by-name/bootoptions /tmp/bootoptions
			cp -f /tmp/bootoptions/STARTUP_ANDROID /tmp/bootoptions/STARTUP_ONCE
		else
			echo "rescue" > /proc/stb/fp/boot_mode
		fi
		/sbin/reboot
		;;
	16)
		if [ -e /dev/block/by-name/bootoptions ]; then
			mkdir -p /tmp/bootoptions
			mount /dev/block/by-name/bootoptions /tmp/bootoptions
			cp -f /tmp/bootoptions/STARTUP_RECOVERY /tmp/bootoptions/STARTUP_ONCE
		else
			echo "rescue" > /proc/stb/fp/boot_mode
		fi
		/sbin/reboot
		;;
	42)
		python /usr/lib/enigma2/python/upgrade.pyo
		;;
	43)
		init 1
		;;
	44)
		# little hack but it will be fixed soon in drivers
		/usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/bin/fbclear
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/wait.mvi
		echo fpupload >/proc/vfd && sleep 3 && dd bs=256k if=/tmp/micom.bin of=/dev/mcu
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/reboot.mvi
		# Wait forever for the user to power off
		while(true) ; do sleep 60 ; done
		;;
	*)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
esac
